/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.lib.sat4j;

import net.fabricmc.loader.impl.lib.sat4j.AbstractLauncher;
import net.fabricmc.loader.impl.lib.sat4j.BasicLauncher;
import net.fabricmc.loader.impl.lib.sat4j.core.ASolverFactory;
import net.fabricmc.loader.impl.lib.sat4j.minisat.constraints.MixedDataStructureDanielWL;
import net.fabricmc.loader.impl.lib.sat4j.minisat.core.SearchParams;
import net.fabricmc.loader.impl.lib.sat4j.minisat.core.Solver;
import net.fabricmc.loader.impl.lib.sat4j.minisat.learning.MiniSATLearning;
import net.fabricmc.loader.impl.lib.sat4j.minisat.orders.RSATPhaseSelectionStrategy;
import net.fabricmc.loader.impl.lib.sat4j.minisat.orders.VarOrderHeap;
import net.fabricmc.loader.impl.lib.sat4j.minisat.restarts.ArminRestarts;
import net.fabricmc.loader.impl.lib.sat4j.specs.ISolver;

public class LightFactory
extends ASolverFactory<ISolver> {
    private static final long serialVersionUID = 1460304168178023681L;
    private static LightFactory instance;

    private static synchronized void createInstance() {
        if (instance == null) {
            instance = new LightFactory();
        }
    }

    public static LightFactory instance() {
        if (instance == null) {
            LightFactory.createInstance();
        }
        return instance;
    }

    @Override
    public ISolver defaultSolver() {
        MiniSATLearning<MixedDataStructureDanielWL> learning = new MiniSATLearning<MixedDataStructureDanielWL>();
        Solver<MixedDataStructureDanielWL> solver = new Solver<MixedDataStructureDanielWL>(learning, new MixedDataStructureDanielWL(), new VarOrderHeap(new RSATPhaseSelectionStrategy()), new ArminRestarts());
        learning.setSolver(solver);
        solver.setSimplifier(solver.EXPENSIVE_SIMPLIFICATION);
        solver.setSearchParams(new SearchParams(1.1, 100));
        return solver;
    }

    @Override
    public ISolver lightSolver() {
        return this.defaultSolver();
    }

    public static void main(String[] args) {
        BasicLauncher<ISolver> lanceur = new BasicLauncher<ISolver>(LightFactory.instance());
        if (args.length != 1) {
            ((AbstractLauncher)lanceur).usage();
            return;
        }
        lanceur.run(args);
        System.exit(lanceur.getExitCode().value());
    }
}

