/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.lib.sat4j.pb;

import net.fabricmc.loader.impl.lib.sat4j.AbstractLauncher;
import net.fabricmc.loader.impl.lib.sat4j.ILauncherMode;
import net.fabricmc.loader.impl.lib.sat4j.core.ASolverFactory;
import net.fabricmc.loader.impl.lib.sat4j.pb.IPBSolver;
import net.fabricmc.loader.impl.lib.sat4j.pb.LanceurPseudo2005;
import net.fabricmc.loader.impl.lib.sat4j.pb.OptToPBSATAdapter;
import net.fabricmc.loader.impl.lib.sat4j.pb.PBSolverHandle;
import net.fabricmc.loader.impl.lib.sat4j.pb.reader.OPBReader2012;
import net.fabricmc.loader.impl.lib.sat4j.pb.tools.OptimalModelIterator;
import net.fabricmc.loader.impl.lib.sat4j.reader.DimacsReader;
import net.fabricmc.loader.impl.lib.sat4j.reader.Reader;
import net.fabricmc.loader.impl.lib.sat4j.specs.ISolver;

public class LanceurPseudo2007
extends LanceurPseudo2005 {
    private static final long serialVersionUID = 1L;
    private PBSolverHandle handle;

    public LanceurPseudo2007() {
    }

    public LanceurPseudo2007(ASolverFactory<IPBSolver> factory) {
        super(factory);
    }

    @Override
    protected Reader createReader(ISolver theSolver, String problemname) {
        if (problemname.endsWith(".cnf")) {
            return new DimacsReader(theSolver);
        }
        return new OPBReader2012(this.handle);
    }

    @Override
    protected void configureLauncher() {
        this.handle = new PBSolverHandle((IPBSolver)this.solver);
        String all = System.getProperty("all");
        if (all != null) {
            this.feedWithDecorated = true;
            this.solver = new OptimalModelIterator(new OptToPBSATAdapter(this.handle));
            this.setLauncherMode(ILauncherMode.DECISION);
        }
        super.configureLauncher();
    }

    public static void main(String[] args) {
        LanceurPseudo2007 lanceur = new LanceurPseudo2007();
        if (args.length == 0 || args.length > 3) {
            ((AbstractLauncher)lanceur).usage();
            return;
        }
        lanceur.addHook();
        lanceur.run(args);
        System.exit(lanceur.getExitCode().value());
    }
}

