/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.lib.sat4j.pb.constraints;

import net.fabricmc.loader.impl.lib.sat4j.minisat.constraints.cnf.BinaryClauses;
import net.fabricmc.loader.impl.lib.sat4j.minisat.constraints.cnf.LearntBinaryClause;
import net.fabricmc.loader.impl.lib.sat4j.minisat.constraints.cnf.LearntWLClause;
import net.fabricmc.loader.impl.lib.sat4j.minisat.constraints.cnf.OriginalWLClause;
import net.fabricmc.loader.impl.lib.sat4j.minisat.constraints.cnf.UnitClause;
import net.fabricmc.loader.impl.lib.sat4j.minisat.core.ILits;
import net.fabricmc.loader.impl.lib.sat4j.pb.constraints.IClauseConstructor;
import net.fabricmc.loader.impl.lib.sat4j.specs.Constr;
import net.fabricmc.loader.impl.lib.sat4j.specs.IVecInt;
import net.fabricmc.loader.impl.lib.sat4j.specs.UnitPropagationListener;

public class UnitConciseBinaryWLClauseConstructor
implements IClauseConstructor {
    private BinaryClauses[] binaryClauses;

    @Override
    public Constr constructClause(UnitPropagationListener solver, ILits voc, IVecInt v) {
        if (v == null) {
            return Constr.TAUTOLOGY;
        }
        if (v.size() == 1) {
            return new UnitClause(v.last());
        }
        if (v.size() == 2) {
            return this.createConciseBinaryClause(v, voc);
        }
        return OriginalWLClause.brandNewClause(solver, voc, v);
    }

    private Constr createConciseBinaryClause(IVecInt literals, ILits voc) {
        BinaryClauses second;
        assert (literals.size() == 2);
        if (this.binaryClauses == null) {
            this.binaryClauses = new BinaryClauses[voc.nVars() * 2 + 2];
        } else if (this.binaryClauses.length < voc.nVars() * 2 + 1) {
            BinaryClauses[] newBinaryClauses = new BinaryClauses[voc.nVars() * 2 + 2];
            System.arraycopy(this.binaryClauses, 0, newBinaryClauses, 0, this.binaryClauses.length);
            this.binaryClauses = newBinaryClauses;
        }
        BinaryClauses first = this.binaryClauses[literals.get(0)];
        if (first == null) {
            first = new BinaryClauses(voc, literals.get(0));
            voc.watch(literals.get(0) ^ 1, first);
            this.binaryClauses[literals.get((int)0)] = first;
        }
        if ((second = this.binaryClauses[literals.get(1)]) == null) {
            second = new BinaryClauses(voc, literals.get(1));
            voc.watch(literals.get(1) ^ 1, second);
            this.binaryClauses[literals.get((int)1)] = second;
        }
        first.addBinaryClause(literals.get(1));
        second.addBinaryClause(literals.get(0));
        return first;
    }

    @Override
    public Constr constructLearntClause(ILits voc, IVecInt literals) {
        if (literals.size() == 1) {
            return new UnitClause(literals.last(), true);
        }
        if (literals.size() == 2) {
            return new LearntBinaryClause(literals, voc);
        }
        return new LearntWLClause(literals, voc);
    }
}

