/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.lib.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import java.util.Map;
import java.util.TreeMap;
import net.fabricmc.loader.impl.lib.sat4j.core.VecInt;
import net.fabricmc.loader.impl.lib.sat4j.pb.constraints.pb.AutoDivisionStrategy;
import net.fabricmc.loader.impl.lib.sat4j.pb.constraints.pb.ConflictMap;
import net.fabricmc.loader.impl.lib.sat4j.pb.constraints.pb.IConflict;
import net.fabricmc.loader.impl.lib.sat4j.pb.constraints.pb.IConflictFactory;
import net.fabricmc.loader.impl.lib.sat4j.pb.constraints.pb.IPostProcess;
import net.fabricmc.loader.impl.lib.sat4j.pb.constraints.pb.IPreProcess;
import net.fabricmc.loader.impl.lib.sat4j.pb.constraints.pb.IWatchPb;
import net.fabricmc.loader.impl.lib.sat4j.pb.constraints.pb.IWeakeningStrategy;
import net.fabricmc.loader.impl.lib.sat4j.pb.constraints.pb.PBConstr;
import net.fabricmc.loader.impl.lib.sat4j.pb.constraints.pb.SkipStrategy;
import net.fabricmc.loader.impl.lib.sat4j.pb.core.PBSolverStats;
import net.fabricmc.loader.impl.lib.sat4j.specs.IVecInt;
import net.fabricmc.loader.impl.lib.sat4j.specs.IteratorInt;

public class ConflictMapWeakenToClash
extends ConflictMap {
    public ConflictMapWeakenToClash(PBConstr cpb, int level, boolean noRemove, SkipStrategy skip, IPreProcess preprocess, IPostProcess postProcessing, IWeakeningStrategy weakeningStrategy, AutoDivisionStrategy autoDivisionStrategy, PBSolverStats stats) {
        super(cpb, level, noRemove, skip, preprocess, postProcessing, weakeningStrategy, autoDivisionStrategy, stats);
    }

    public static IConflict createConflict(PBConstr cpb, int level, boolean noRemove, SkipStrategy skip, IPreProcess preprocess, IPostProcess postProcessing, IWeakeningStrategy weakeningStrategy, AutoDivisionStrategy autoDivisionStrategy, PBSolverStats stats) {
        return new ConflictMapWeakenToClash(cpb, level, noRemove, skip, preprocess, postProcessing, weakeningStrategy, autoDivisionStrategy, stats);
    }

    public static IConflictFactory factory() {
        return new IConflictFactory(){

            @Override
            public IConflict createConflict(PBConstr cpb, int level, boolean noRemove, SkipStrategy skip, IPreProcess preprocess, IPostProcess postprocess, IWeakeningStrategy weakeningStrategy, AutoDivisionStrategy autoDivisionStrategy, PBSolverStats stats) {
                return ConflictMapWeakenToClash.createConflict(cpb, level, noRemove, skip, preprocess, postprocess, weakeningStrategy, autoDivisionStrategy, stats);
            }

            public String toString() {
                return "Weaken reason to find a multiple of the pivot";
            }
        };
    }

    @Override
    protected BigInteger reduceUntilConflict(int litImplied, int ind, BigInteger[] reducedCoefs, BigInteger degreeReduced, IWatchPb wpb) {
        int index;
        IteratorInt it;
        BigInteger coef;
        BigInteger slackIndex;
        BigInteger slackResolve = BigInteger.ONE.negate();
        BigInteger slackThis = BigInteger.ZERO;
        BigInteger slackConflict = this.slackConflict();
        BigInteger reducedDegree = degreeReduced;
        BigInteger previousCoefLitImplied = BigInteger.ZERO;
        BigInteger[] mult = new BigInteger[]{BigInteger.ONE, BigInteger.ONE, BigInteger.ZERO};
        BigInteger coefLitImplied = this.weightedLits.get(litImplied ^ 1);
        this.possReducedCoefs = this.possConstraint(wpb, reducedCoefs);
        do {
            if (slackResolve.signum() >= 0) {
                assert (slackThis.signum() > 0);
                BigInteger tmp = this.reduceInConstraint(wpb, reducedCoefs, ind, reducedDegree, slackResolve);
                assert (tmp.compareTo(reducedDegree) < 0 && tmp.compareTo(BigInteger.ONE) >= 0);
                reducedDegree = tmp;
            }
            assert (this.weightedLits.get(litImplied ^ 1).signum() > 0);
            assert (reducedCoefs[ind].signum() > 0);
            if (!reducedCoefs[ind].equals(previousCoefLitImplied)) {
                assert (coefLitImplied.equals(this.weightedLits.get(litImplied ^ 1)));
                mult = this.findMult(coefLitImplied, reducedCoefs[ind]);
                assert (mult[0].signum() > 0);
                assert (mult[1].signum() > 0);
                this.coefMult = mult[0];
                this.coefMultCons = mult[1];
                assert (this.coefMult.multiply(coefLitImplied).equals(this.coefMultCons.multiply(reducedCoefs[ind]).subtract(mult[2])));
                previousCoefLitImplied = reducedCoefs[ind];
            }
            slackThis = this.possReducedCoefs.subtract(reducedDegree).multiply(this.coefMultCons);
            assert (slackThis.equals(wpb.slackConstraint(reducedCoefs, reducedDegree).multiply(this.coefMultCons)));
            assert (slackConflict.equals(this.slackConflict()));
            slackIndex = slackConflict.multiply(this.coefMult);
            assert (slackIndex.signum() <= 0);
        } while ((slackResolve = slackThis.add(slackIndex)).signum() >= 0 || this.isUnsat());
        TreeMap<BigInteger, IVecInt> coefsSat = new TreeMap<BigInteger, IVecInt>();
        TreeMap<BigInteger, IVecInt> coefsFals = new TreeMap<BigInteger, IVecInt>();
        for (int i = 0; i < reducedCoefs.length; ++i) {
            IVecInt lits;
            BigInteger coef2;
            reducedCoefs[i] = coef2 = reducedCoefs[i].multiply(this.coefMultCons);
            if (!this.voc.isFalsified(wpb.get(i)) && i != ind) {
                lits = (IVecInt)coefsSat.get(coef2);
                if (lits == null) {
                    lits = new VecInt();
                    coefsSat.put(coef2, lits);
                }
                lits.push(i);
                continue;
            }
            if (!this.voc.isFalsified(wpb.get(i))) continue;
            lits = (IVecInt)coefsFals.get(coef2);
            if (lits == null) {
                lits = new VecInt();
                coefsFals.put(coef2, lits);
            }
            lits.push(i);
        }
        reducedDegree = reducedDegree.multiply(this.coefMultCons);
        this.coefMultCons = BigInteger.ONE;
        if (mult[2].signum() == 0) {
            if ((reducedDegree = this.saturation(reducedCoefs, reducedDegree, wpb)).equals(BigInteger.ONE)) {
                this.coefMultCons = coefLitImplied;
            }
            return reducedDegree;
        }
        BigInteger expected = this.coefMult.multiply(coefLitImplied);
        BigInteger toWeaken = reducedDegree.subtract(expected);
        assert (toWeaken.signum() >= 0);
        block2: for (Map.Entry entry : coefsSat.entrySet()) {
            if (toWeaken.signum() == 0) break;
            coef = (BigInteger)entry.getKey();
            it = ((IVecInt)entry.getValue()).iterator();
            while (it.hasNext()) {
                index = it.next();
                if (coef.compareTo(toWeaken) > 0) {
                    reducedCoefs[index] = coef.subtract(toWeaken);
                    reducedDegree = reducedDegree.subtract(toWeaken);
                    toWeaken = BigInteger.ZERO;
                    continue block2;
                }
                reducedCoefs[index] = BigInteger.ZERO;
                toWeaken = toWeaken.subtract(coef);
                reducedDegree = reducedDegree.subtract(coef);
            }
        }
        if (toWeaken.signum() > 0 && reducedCoefs[ind].compareTo(reducedDegree) < 0) {
            block4: for (Map.Entry entry : coefsFals.entrySet()) {
                if (toWeaken.signum() == 0) break;
                coef = (BigInteger)entry.getKey();
                it = ((IVecInt)entry.getValue()).iterator();
                while (it.hasNext()) {
                    index = it.next();
                    if (this.weightedLits.containsKey(wpb.get(index) ^ 1)) continue;
                    this.stats.incFalsifiedLiteralsRemovedFromReason();
                    if (coef.compareTo(toWeaken) > 0) {
                        reducedCoefs[index] = coef.subtract(toWeaken);
                        reducedDegree = reducedDegree.subtract(toWeaken);
                        toWeaken = BigInteger.ZERO;
                        continue block4;
                    }
                    reducedCoefs[index] = BigInteger.ZERO;
                    toWeaken = toWeaken.subtract(coef);
                    reducedDegree = reducedDegree.subtract(coef);
                }
            }
        }
        if (toWeaken.signum() > 0) {
            toWeaken = toWeaken.min(reducedCoefs[ind].subtract(expected));
            reducedCoefs[ind] = reducedCoefs[ind].subtract(toWeaken);
            reducedDegree = reducedDegree.subtract(toWeaken);
        }
        if ((reducedDegree = this.saturation(reducedCoefs, reducedDegree, wpb)).equals(BigInteger.ONE)) {
            this.coefMultCons = coefLitImplied;
            this.coefMult = BigInteger.ONE;
        }
        return reducedDegree;
    }

    protected BigInteger[] findMult(BigInteger conflict, BigInteger reason) {
        int cmp = conflict.compareTo(reason);
        if (cmp == 0) {
            return new BigInteger[]{BigInteger.ONE, BigInteger.ONE, BigInteger.ZERO};
        }
        if (cmp < 0) {
            BigInteger[] divMod = reason.divideAndRemainder(conflict);
            return new BigInteger[]{divMod[0], BigInteger.ONE, divMod[1]};
        }
        BigInteger[] divMod = conflict.divideAndRemainder(reason);
        if (divMod[1].signum() == 0) {
            return new BigInteger[]{BigInteger.ONE, divMod[0], BigInteger.ZERO};
        }
        return new BigInteger[]{BigInteger.ONE, divMod[0].add(BigInteger.ONE), reason.subtract(divMod[1])};
    }
}

