/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.lib.accesswidener;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import net.fabricmc.loader.impl.lib.accesswidener.AccessWidenerFormatException;
import net.fabricmc.loader.impl.lib.accesswidener.AccessWidenerVisitor;

public final class AccessWidenerReader {
    public static final Charset ENCODING = StandardCharsets.UTF_8;
    private static final Pattern V1_DELIMITER = Pattern.compile("\\s+");
    private static final Pattern V2_DELIMITER = Pattern.compile("[ \\t]+");
    private static final String TRANSITIVE_PREFIX = "transitive-";
    private static final int V1 = 1;
    private static final int V2 = 2;
    private final AccessWidenerVisitor visitor;
    private int lineNumber;

    public AccessWidenerReader(AccessWidenerVisitor visitor) {
        this.visitor = visitor;
    }

    public static int readVersion(byte[] content) {
        return AccessWidenerReader.readHeader(content).version;
    }

    public static int readVersion(BufferedReader reader) throws IOException {
        return AccessWidenerReader.readHeader(reader).version;
    }

    public void read(byte[] content) {
        this.read(content, null);
    }

    public void read(byte[] content, String currentNamespace) {
        String strContent = new String(content, ENCODING);
        try {
            this.read(new BufferedReader(new StringReader(strContent)), currentNamespace);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void read(BufferedReader reader) throws IOException {
        this.read(reader, null);
    }

    public void read(BufferedReader reader, String currentNamespace) throws IOException {
        String line;
        Pattern delimiter;
        Header header = AccessWidenerReader.readHeader(reader);
        this.lineNumber = 1;
        int version = header.version;
        if (currentNamespace != null && !header.namespace.equals(currentNamespace)) {
            throw this.error("Namespace (%s) does not match current runtime namespace (%s)", header.namespace, currentNamespace);
        }
        this.visitor.visitHeader(header.namespace);
        Pattern pattern = delimiter = version < 2 ? V1_DELIMITER : V2_DELIMITER;
        block10: while ((line = reader.readLine()) != null) {
            ++this.lineNumber;
            if ((line = this.handleComment(version, line)).isEmpty()) continue;
            if (Character.isWhitespace(line.codePointAt(0))) {
                throw this.error("Leading whitespace is not allowed", new Object[0]);
            }
            List<String> tokens = Arrays.asList(delimiter.split(line));
            String accessType = tokens.get(0);
            boolean transitive = false;
            if (version >= 2 && accessType.startsWith(TRANSITIVE_PREFIX)) {
                accessType = accessType.substring(TRANSITIVE_PREFIX.length());
                transitive = true;
            }
            AccessType access = this.readAccessType(accessType);
            if (tokens.size() < 2) {
                throw this.error("Expected <class|field|method> following " + tokens.get(0), new Object[0]);
            }
            switch (tokens.get(1)) {
                case "class": {
                    this.handleClass(line, tokens, transitive, access);
                    continue block10;
                }
                case "field": {
                    this.handleField(line, tokens, transitive, access);
                    continue block10;
                }
                case "method": {
                    this.handleMethod(line, tokens, transitive, access);
                    continue block10;
                }
            }
            throw this.error("Unsupported type: '" + tokens.get(1) + "'", new Object[0]);
        }
    }

    public static Header readHeader(byte[] content) {
        String strContent = new String(content, ENCODING);
        try {
            return AccessWidenerReader.readHeader(new BufferedReader(new StringReader(strContent)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Header readHeader(BufferedReader reader) throws IOException {
        int version;
        String headerLine = reader.readLine();
        String[] header = headerLine.split("\\s+");
        if (header.length != 3 || !header[0].equals("accessWidener")) {
            throw new AccessWidenerFormatException(1, "Invalid access widener file header. Expected: 'accessWidener <version> <namespace>'");
        }
        switch (header[1]) {
            case "v1": {
                version = 1;
                break;
            }
            case "v2": {
                version = 2;
                break;
            }
            default: {
                throw new AccessWidenerFormatException(1, "Unsupported access widener format: " + header[1]);
            }
        }
        return new Header(version, header[2]);
    }

    private void handleClass(String line, List<String> tokens, boolean transitive, AccessType access) {
        if (tokens.size() != 3) {
            throw this.error("Expected (<access> class <className>) got (%s)", line);
        }
        String name = tokens.get(2);
        this.validateClassName(name);
        try {
            this.visitor.visitClass(name, access, transitive);
        }
        catch (Exception e) {
            throw this.error(e.toString(), new Object[0]);
        }
    }

    private void handleField(String line, List<String> tokens, boolean transitive, AccessType access) {
        if (tokens.size() != 5) {
            throw this.error("Expected (<access> field <className> <fieldName> <fieldDesc>) got (%s)", line);
        }
        String owner = tokens.get(2);
        String fieldName = tokens.get(3);
        String descriptor = tokens.get(4);
        this.validateClassName(owner);
        try {
            this.visitor.visitField(owner, fieldName, descriptor, access, transitive);
        }
        catch (Exception e) {
            throw this.error(e.toString(), new Object[0]);
        }
    }

    private void handleMethod(String line, List<String> tokens, boolean transitive, AccessType access) {
        if (tokens.size() != 5) {
            throw this.error("Expected (<access> method <className> <methodName> <methodDesc>) got (%s)", line);
        }
        String owner = tokens.get(2);
        String methodName = tokens.get(3);
        String descriptor = tokens.get(4);
        this.validateClassName(owner);
        try {
            this.visitor.visitMethod(owner, methodName, descriptor, access, transitive);
        }
        catch (Exception e) {
            throw this.error(e.toString(), new Object[0]);
        }
    }

    private String handleComment(int version, String line) {
        int commentPos = line.indexOf(35);
        if (commentPos >= 0) {
            line = line.substring(0, commentPos);
            if (version <= 1) {
                line = line.trim();
            }
        }
        return line;
    }

    private AccessType readAccessType(String access) {
        switch (access.toLowerCase(Locale.ROOT)) {
            case "accessible": {
                return AccessType.ACCESSIBLE;
            }
            case "extendable": {
                return AccessType.EXTENDABLE;
            }
            case "mutable": {
                return AccessType.MUTABLE;
            }
        }
        throw this.error("Unknown access type: " + access, new Object[0]);
    }

    private AccessWidenerFormatException error(String format, Object ... args) {
        String message = String.format(Locale.ROOT, format, args);
        return new AccessWidenerFormatException(this.lineNumber, message);
    }

    private void validateClassName(String className) {
        if (className.contains(".")) {
            throw this.error("Class-names must be specified as a/b/C, not a.b.C, but found: %s", className);
        }
    }

    public static class Header {
        private final int version;
        private final String namespace;

        Header(int version, String namespace) {
            this.version = version;
            this.namespace = namespace;
        }

        public int getVersion() {
            return this.version;
        }

        public String getNamespace() {
            return this.namespace;
        }
    }

    public static enum AccessType {
        ACCESSIBLE("accessible"),
        EXTENDABLE("extendable"),
        MUTABLE("mutable");

        private final String id;

        private AccessType(String id) {
            this.id = id;
        }

        public String toString() {
            return this.id;
        }
    }
}

