/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.lib.mappingio;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.loader.impl.lib.mappingio.MappingFlag;
import net.fabricmc.loader.impl.lib.mappingio.MappingUtil;
import net.fabricmc.loader.impl.lib.mappingio.MappingVisitor;
import net.fabricmc.loader.impl.lib.mappingio.adapter.FlatAsRegularMappingVisitor;
import net.fabricmc.loader.impl.lib.mappingio.adapter.RegularAsFlatMappingVisitor;
import org.jetbrains.annotations.Nullable;

public interface FlatMappingVisitor {
    default public Set<MappingFlag> getFlags() {
        return MappingFlag.NONE;
    }

    default public void reset() {
        throw new UnsupportedOperationException();
    }

    default public boolean visitHeader() throws IOException {
        return true;
    }

    public void visitNamespaces(String var1, List<String> var2) throws IOException;

    default public void visitMetadata(String key, @Nullable String value) throws IOException {
    }

    default public boolean visitContent() throws IOException {
        return true;
    }

    public boolean visitClass(String var1, @Nullable String[] var2) throws IOException;

    public void visitClassComment(String var1, @Nullable String[] var2, String var3) throws IOException;

    public boolean visitField(String var1, String var2, @Nullable String var3, @Nullable String[] var4, @Nullable String[] var5, @Nullable String[] var6) throws IOException;

    public void visitFieldComment(String var1, String var2, @Nullable String var3, @Nullable String[] var4, @Nullable String[] var5, @Nullable String[] var6, String var7) throws IOException;

    public boolean visitMethod(String var1, String var2, @Nullable String var3, @Nullable String[] var4, @Nullable String[] var5, @Nullable String[] var6) throws IOException;

    public void visitMethodComment(String var1, String var2, @Nullable String var3, @Nullable String[] var4, @Nullable String[] var5, @Nullable String[] var6, String var7) throws IOException;

    public boolean visitMethodArg(String var1, String var2, @Nullable String var3, int var4, int var5, @Nullable String var6, @Nullable String[] var7, @Nullable String[] var8, @Nullable String[] var9, String[] var10) throws IOException;

    public void visitMethodArgComment(String var1, String var2, @Nullable String var3, int var4, int var5, @Nullable String var6, @Nullable String[] var7, @Nullable String[] var8, @Nullable String[] var9, @Nullable String[] var10, String var11) throws IOException;

    public boolean visitMethodVar(String var1, String var2, @Nullable String var3, int var4, int var5, int var6, int var7, @Nullable String var8, @Nullable String[] var9, @Nullable String[] var10, @Nullable String[] var11, String[] var12) throws IOException;

    public void visitMethodVarComment(String var1, String var2, @Nullable String var3, int var4, int var5, int var6, int var7, @Nullable String var8, @Nullable String[] var9, @Nullable String[] var10, @Nullable String[] var11, @Nullable String[] var12, String var13) throws IOException;

    default public boolean visitEnd() throws IOException {
        return true;
    }

    default public MappingVisitor asRegularVisitor() {
        return new FlatAsRegularMappingVisitor(this);
    }

    public static FlatMappingVisitor fromRegularVisitor(MappingVisitor visitor) {
        return new RegularAsFlatMappingVisitor(visitor);
    }

    default public boolean visitField(String srcClsName, String srcName, @Nullable String srcDesc, String[] dstNames) throws IOException {
        Objects.requireNonNull(dstNames);
        return this.visitField(srcClsName, srcName, srcDesc, null, dstNames, null);
    }

    default public boolean visitMethod(String srcClsName, String srcName, @Nullable String srcDesc, String[] dstNames) throws IOException {
        Objects.requireNonNull(dstNames);
        return this.visitMethod(srcClsName, srcName, srcDesc, null, dstNames, null);
    }

    default public boolean visitMethodArg(String srcClsName, String srcMethodName, @Nullable String srcMethodDesc, int argPosition, int lvIndex, @Nullable String srcName, String[] dstNames) throws IOException {
        Objects.requireNonNull(dstNames);
        return this.visitMethodArg(srcClsName, srcMethodName, srcMethodDesc, argPosition, lvIndex, srcName, null, null, null, dstNames);
    }

    default public boolean visitMethodVar(String srcClsName, String srcMethodName, @Nullable String srcMethodDesc, int lvtRowIndex, int lvIndex, int startOpIdx, int endOpIdx, @Nullable String srcName, String[] dstNames) throws IOException {
        Objects.requireNonNull(dstNames);
        return this.visitMethodVar(srcClsName, srcMethodName, srcMethodDesc, lvtRowIndex, lvIndex, startOpIdx, endOpIdx, srcName, null, null, null, dstNames);
    }

    default public boolean visitClass(String srcName, String dstName) throws IOException {
        return this.visitClass(srcName, MappingUtil.toArray(dstName));
    }

    default public void visitClassComment(String srcName, String comment) throws IOException {
        this.visitClassComment(srcName, (String)null, comment);
    }

    default public void visitClassComment(String srcName, @Nullable String dstName, String comment) throws IOException {
        this.visitClassComment(srcName, MappingUtil.toArray(dstName), comment);
    }

    default public boolean visitField(String srcClsName, String srcName, @Nullable String srcDesc, String dstName) throws IOException {
        return this.visitField(srcClsName, srcName, srcDesc, null, dstName, null);
    }

    default public boolean visitField(String srcClsName, String srcName, @Nullable String srcDesc, @Nullable String dstClsName, String dstName, @Nullable String dstDesc) throws IOException {
        return this.visitField(srcClsName, srcName, srcDesc, MappingUtil.toArray(dstClsName), MappingUtil.toArray(dstName), MappingUtil.toArray(dstDesc));
    }

    default public void visitFieldComment(String srcClsName, String srcName, @Nullable String srcDesc, String comment) throws IOException {
        this.visitFieldComment(srcClsName, srcName, srcDesc, (String)null, null, null, comment);
    }

    default public void visitFieldComment(String srcClsName, String srcName, @Nullable String srcDesc, @Nullable String dstClsName, @Nullable String dstName, @Nullable String dstDesc, String comment) throws IOException {
        this.visitFieldComment(srcClsName, srcName, srcDesc, MappingUtil.toArray(dstClsName), MappingUtil.toArray(dstName), MappingUtil.toArray(dstDesc), comment);
    }

    default public boolean visitMethod(String srcClsName, String srcName, @Nullable String srcDesc, String dstName) throws IOException {
        return this.visitMethod(srcClsName, srcName, srcDesc, null, dstName, null);
    }

    default public boolean visitMethod(String srcClsName, String srcName, @Nullable String srcDesc, @Nullable String dstClsName, String dstName, @Nullable String dstDesc) throws IOException {
        return this.visitMethod(srcClsName, srcName, srcDesc, MappingUtil.toArray(dstClsName), MappingUtil.toArray(dstName), MappingUtil.toArray(dstDesc));
    }

    default public void visitMethodComment(String srcClsName, String srcName, @Nullable String srcDesc, String comment) throws IOException {
        this.visitMethodComment(srcClsName, srcName, srcDesc, (String)null, null, null, comment);
    }

    default public void visitMethodComment(String srcClsName, String srcName, @Nullable String srcDesc, @Nullable String dstClsName, @Nullable String dstName, @Nullable String dstDesc, String comment) throws IOException {
        this.visitMethodComment(srcClsName, srcName, srcDesc, MappingUtil.toArray(dstClsName), MappingUtil.toArray(dstName), MappingUtil.toArray(dstDesc), comment);
    }

    default public boolean visitMethodArg(String srcClsName, String srcMethodName, @Nullable String srcMethodDesc, int argPosition, int lvIndex, @Nullable String srcName, String dstName) throws IOException {
        return this.visitMethodArg(srcClsName, srcMethodName, srcMethodDesc, argPosition, lvIndex, srcName, null, null, null, dstName);
    }

    default public boolean visitMethodArg(String srcClsName, String srcMethodName, @Nullable String srcMethodDesc, int argPosition, int lvIndex, @Nullable String srcName, @Nullable String dstClsName, @Nullable String dstMethodName, @Nullable String dstMethodDesc, String dstName) throws IOException {
        return this.visitMethodArg(srcClsName, srcMethodName, srcMethodDesc, argPosition, lvIndex, srcName, MappingUtil.toArray(dstClsName), MappingUtil.toArray(dstMethodName), MappingUtil.toArray(dstMethodDesc), MappingUtil.toArray(dstName));
    }

    default public void visitMethodArgComment(String srcClsName, String srcMethodName, @Nullable String srcMethodDesc, int argPosition, int lvIndex, @Nullable String srcName, String comment) throws IOException {
        this.visitMethodArgComment(srcClsName, srcMethodName, srcMethodDesc, argPosition, lvIndex, srcName, (String)null, null, null, null, comment);
    }

    default public void visitMethodArgComment(String srcClsName, String srcMethodName, @Nullable String srcMethodDesc, int argPosition, int lvIndex, @Nullable String srcName, @Nullable String dstClsName, @Nullable String dstMethodName, @Nullable String dstMethodDesc, @Nullable String dstName, String comment) throws IOException {
        this.visitMethodArgComment(srcClsName, srcMethodName, srcMethodDesc, argPosition, lvIndex, srcName, MappingUtil.toArray(dstClsName), MappingUtil.toArray(dstMethodName), MappingUtil.toArray(dstMethodDesc), MappingUtil.toArray(dstName), comment);
    }

    default public boolean visitMethodVar(String srcClsName, String srcMethodName, @Nullable String srcMethodDesc, int lvtRowIndex, int lvIndex, int startOpIdx, int endOpIdx, @Nullable String srcName, String dstName) throws IOException {
        return this.visitMethodVar(srcClsName, srcMethodName, srcMethodDesc, lvtRowIndex, lvIndex, startOpIdx, endOpIdx, srcName, null, null, null, dstName);
    }

    default public boolean visitMethodVar(String srcClsName, String srcMethodName, @Nullable String srcMethodDesc, int lvtRowIndex, int lvIndex, int startOpIdx, int endOpIdx, @Nullable String srcName, @Nullable String dstClsName, @Nullable String dstMethodName, @Nullable String dstMethodDesc, String dstName) throws IOException {
        return this.visitMethodVar(srcClsName, srcMethodName, srcMethodDesc, lvtRowIndex, lvIndex, startOpIdx, endOpIdx, srcName, MappingUtil.toArray(dstClsName), MappingUtil.toArray(dstMethodName), MappingUtil.toArray(dstMethodDesc), MappingUtil.toArray(dstName));
    }

    default public void visitMethodVarComment(String srcClsName, String srcMethodName, @Nullable String srcMethodDesc, int lvtRowIndex, int lvIndex, int startOpIdx, int endOpIdx, @Nullable String srcName, String comment) throws IOException {
        this.visitMethodVarComment(srcClsName, srcMethodName, srcMethodDesc, lvtRowIndex, lvIndex, startOpIdx, endOpIdx, srcName, (String)null, null, null, null, comment);
    }

    default public void visitMethodVarComment(String srcClsName, String srcMethodName, @Nullable String srcMethodDesc, int lvtRowIndex, int lvIndex, int startOpIdx, int endOpIdx, @Nullable String srcName, @Nullable String dstClsName, @Nullable String dstMethodName, @Nullable String dstMethodDesc, @Nullable String dstName, String comment) throws IOException {
        this.visitMethodVarComment(srcClsName, srcMethodName, srcMethodDesc, lvtRowIndex, lvIndex, startOpIdx, endOpIdx, srcName, MappingUtil.toArray(dstClsName), MappingUtil.toArray(dstMethodName), MappingUtil.toArray(dstMethodDesc), MappingUtil.toArray(dstName), comment);
    }
}

