/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.lib.mappingio.format;

import org.jetbrains.annotations.Nullable;

public enum MappingFormat {
    TINY_FILE("Tiny file", "tiny", true, true, false, false, false),
    TINY_2_FILE("Tiny v2 file", "tiny", true, true, true, true, true),
    ENIGMA_FILE("Enigma file", "mapping", false, true, true, true, false),
    ENIGMA_DIR("Enigma directory", null, false, true, true, true, false),
    SRG_FILE("SRG file", "srg", false, false, false, false, false),
    XSRG_FILE("XSRG file", "xsrg", false, true, false, false, false),
    CSRG_FILE("CSRG file", "csrg", false, false, false, false, false),
    TSRG_FILE("TSRG file", "tsrg", false, false, false, false, false),
    TSRG_2_FILE("TSRG2 file", "tsrg", true, true, false, true, false),
    PROGUARD_FILE("ProGuard file", "txt", false, true, false, false, false);

    public final String name;
    @Nullable
    public final String fileExt;
    public final boolean hasNamespaces;
    public final boolean hasFieldDescriptors;
    public final boolean supportsComments;
    public final boolean supportsArgs;
    public final boolean supportsLocals;

    private MappingFormat(String name, String fileExt, boolean hasNamespaces, boolean hasFieldDescriptors, boolean supportsComments, boolean supportsArgs, boolean supportsLocals) {
        this.name = name;
        this.fileExt = fileExt;
        this.hasNamespaces = hasNamespaces;
        this.hasFieldDescriptors = hasFieldDescriptors;
        this.supportsComments = supportsComments;
        this.supportsArgs = supportsArgs;
        this.supportsLocals = supportsLocals;
    }

    public boolean hasSingleFile() {
        return this.fileExt != null;
    }

    public String getGlobPattern() {
        if (this.fileExt == null) {
            throw new UnsupportedOperationException("not applicable to dir based format");
        }
        return "*." + this.fileExt;
    }
}

