/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.lib.sat4j.minisat.constraints;

import net.fabricmc.loader.impl.lib.sat4j.minisat.constraints.AbstractDataStructureFactory;
import net.fabricmc.loader.impl.lib.sat4j.minisat.constraints.card.AtLeast;
import net.fabricmc.loader.impl.lib.sat4j.minisat.constraints.cnf.Clauses;
import net.fabricmc.loader.impl.lib.sat4j.minisat.constraints.cnf.LearntBinaryClause;
import net.fabricmc.loader.impl.lib.sat4j.minisat.constraints.cnf.LearntWLClause;
import net.fabricmc.loader.impl.lib.sat4j.minisat.constraints.cnf.Lits;
import net.fabricmc.loader.impl.lib.sat4j.minisat.constraints.cnf.OriginalBinaryClause;
import net.fabricmc.loader.impl.lib.sat4j.minisat.constraints.cnf.OriginalWLClause;
import net.fabricmc.loader.impl.lib.sat4j.minisat.constraints.cnf.UnitClause;
import net.fabricmc.loader.impl.lib.sat4j.minisat.core.ILits;
import net.fabricmc.loader.impl.lib.sat4j.specs.Constr;
import net.fabricmc.loader.impl.lib.sat4j.specs.ContradictionException;
import net.fabricmc.loader.impl.lib.sat4j.specs.IVecInt;

public class MixedDataStructureDanielWL
extends AbstractDataStructureFactory {
    private static final long serialVersionUID = 1L;

    @Override
    public Constr createCardinalityConstraint(IVecInt literals, int degree) throws ContradictionException {
        return AtLeast.atLeastNew(this.solver, this.getVocabulary(), literals, degree);
    }

    @Override
    public Constr createUnregisteredCardinalityConstraint(IVecInt literals, int degree) {
        return new AtLeast(this.getVocabulary(), literals, degree);
    }

    @Override
    public Constr createClause(IVecInt literals) throws ContradictionException {
        IVecInt v = Clauses.sanityCheck(literals, this.getVocabulary(), this.solver);
        if (v == null) {
            return null;
        }
        if (v.size() == 1) {
            return new UnitClause(v.last());
        }
        if (v.size() == 2) {
            return OriginalBinaryClause.brandNewClause(this.solver, this.getVocabulary(), v);
        }
        return OriginalWLClause.brandNewClause(this.solver, this.getVocabulary(), v);
    }

    @Override
    public Constr createUnregisteredClause(IVecInt literals) {
        if (literals.size() == 1) {
            return new UnitClause(literals.last(), true);
        }
        if (literals.size() == 2) {
            return new LearntBinaryClause(literals, this.getVocabulary());
        }
        return new LearntWLClause(literals, this.getVocabulary());
    }

    @Override
    protected ILits createLits() {
        return new Lits();
    }
}

