/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.lib.sat4j.pb;

import java.math.BigInteger;
import net.fabricmc.loader.impl.lib.sat4j.core.VecInt;
import net.fabricmc.loader.impl.lib.sat4j.pb.IPBSolver;
import net.fabricmc.loader.impl.lib.sat4j.pb.PBSolverDecorator;
import net.fabricmc.loader.impl.lib.sat4j.specs.ContradictionException;
import net.fabricmc.loader.impl.lib.sat4j.specs.IConstr;
import net.fabricmc.loader.impl.lib.sat4j.specs.IOptimizationProblem;
import net.fabricmc.loader.impl.lib.sat4j.specs.IVecInt;
import net.fabricmc.loader.impl.lib.sat4j.specs.TimeoutException;

public class ConstraintRelaxingPseudoOptDecorator
extends PBSolverDecorator
implements IOptimizationProblem {
    private static final long serialVersionUID = 1L;
    private IConstr previousPBConstr;
    private IConstr addedConstr = null;
    private Number objectiveValue;
    private boolean optimumFound = false;

    public ConstraintRelaxingPseudoOptDecorator(IPBSolver solver) {
        super(solver);
    }

    @Override
    public boolean isSatisfiable() throws TimeoutException {
        return this.isSatisfiable(VecInt.EMPTY);
    }

    @Override
    public boolean isSatisfiable(boolean global) throws TimeoutException {
        return this.isSatisfiable(VecInt.EMPTY, global);
    }

    @Override
    public boolean isSatisfiable(IVecInt assumps, boolean global) throws TimeoutException {
        boolean result = super.isSatisfiable(assumps, true);
        if (result) {
            this.calculateObjective();
        } else if (this.previousPBConstr != null) {
            ((IPBSolver)this.decorated()).removeConstr(this.previousPBConstr);
            this.previousPBConstr = null;
        }
        return result;
    }

    @Override
    public boolean isSatisfiable(IVecInt assumps) throws TimeoutException {
        return this.isSatisfiable(assumps, true);
    }

    @Override
    public boolean admitABetterSolution() throws TimeoutException {
        return this.admitABetterSolution(VecInt.EMPTY);
    }

    @Override
    public boolean admitABetterSolution(IVecInt assumps) throws TimeoutException {
        if (this.optimumFound) {
            return false;
        }
        int maxValue = this.getObjectiveFunction().minValue().intValue();
        while (true) {
            if (this.addedConstr != null) {
                ((IPBSolver)this.decorated()).removeConstr(this.addedConstr);
            }
            try {
                this.forceObjectiveValueTo(maxValue++);
            }
            catch (ContradictionException e) {
                if (!this.isVerbose()) continue;
                System.out.println(((IPBSolver)this.decorated()).getLogPrefix() + "no solution for objective value " + (maxValue - 1));
                continue;
            }
            boolean isSatisfiable = super.isSatisfiable(assumps, true);
            if (isSatisfiable) {
                this.optimumFound = true;
                if (this.getObjectiveFunction() != null) {
                    this.calculateObjective();
                }
                ((IPBSolver)this.decorated()).removeConstr(this.addedConstr);
                return true;
            }
            if (!this.isVerbose()) continue;
            System.out.println(((IPBSolver)this.decorated()).getLogPrefix() + "no solution for objective value " + (maxValue - 1));
        }
    }

    @Override
    public boolean hasNoObjectiveFunction() {
        return this.getObjectiveFunction() == null;
    }

    @Override
    public boolean nonOptimalMeansSatisfiable() {
        return false;
    }

    @Override
    @Deprecated
    public Number calculateObjective() {
        if (this.getObjectiveFunction() == null) {
            throw new UnsupportedOperationException("The problem does not contain an objective function");
        }
        this.objectiveValue = this.getObjectiveFunction().calculateDegree(this);
        return this.objectiveValue;
    }

    @Override
    public Number getObjectiveValue() {
        return this.objectiveValue;
    }

    @Override
    public void forceObjectiveValueTo(Number forcedValue) throws ContradictionException {
        this.addedConstr = super.addPseudoBoolean(this.getObjectiveFunction().getVars(), this.getObjectiveFunction().getCoeffs(), false, BigInteger.valueOf(forcedValue.longValue()));
    }

    @Override
    @Deprecated
    public void discard() {
        this.discardCurrentSolution();
    }

    @Override
    public void discardCurrentSolution() {
    }

    @Override
    public boolean isOptimal() {
        return this.optimumFound;
    }

    @Override
    public String toString(String prefix) {
        return prefix + "Pseudo Boolean Optimization by lower bound\n" + super.toString(prefix);
    }

    @Override
    public void setTimeoutForFindingBetterSolution(int seconds) {
        throw new UnsupportedOperationException("Does not make sense here");
    }
}

