/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.lib.sat4j.pb.orders;

import java.math.BigInteger;
import net.fabricmc.loader.impl.lib.sat4j.core.VecInt;
import net.fabricmc.loader.impl.lib.sat4j.minisat.core.ILits;
import net.fabricmc.loader.impl.lib.sat4j.minisat.core.IOrder;
import net.fabricmc.loader.impl.lib.sat4j.pb.constraints.pb.PBConstr;
import net.fabricmc.loader.impl.lib.sat4j.pb.orders.BumpStrategy;
import net.fabricmc.loader.impl.lib.sat4j.pb.orders.IBumper;
import net.fabricmc.loader.impl.lib.sat4j.specs.IVecInt;
import net.fabricmc.loader.impl.lib.sat4j.specs.IteratorInt;

public class BumperEffective
implements IBumper {
    private BigInteger constrDegree;
    private final IVecInt bumpableCandidates = new VecInt();
    private BumpStrategy bumpStrategy;

    @Override
    public void varBumpActivity(ILits voc, BumpStrategy bStrategy, IOrder order, PBConstr constr, int lit, int propagated) {
        if (lit == 0) {
            this.constrDegree = constr.getDegree();
            this.bumpableCandidates.clear();
            this.bumpStrategy = bStrategy;
        }
        if (lit == propagated) {
            bStrategy.varBumpActivity(order, constr, lit);
        } else if (!voc.isFalsified(constr.get(lit))) {
            this.constrDegree = this.constrDegree.subtract(constr.getCoef(lit));
        } else {
            this.bumpableCandidates.push(lit);
        }
    }

    @Override
    public void postBumpActivity(IOrder order, PBConstr constr) {
        int v;
        IteratorInt it = this.bumpableCandidates.iterator();
        while (it.hasNext() && constr.getCoef(v = it.next()).compareTo(this.constrDegree) >= 0) {
            this.bumpStrategy.varBumpActivity(order, constr, v);
        }
    }

    public String toString() {
        return "EFFECTIVE";
    }
}

