/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.lib.sat4j.tools;

import net.fabricmc.loader.impl.lib.sat4j.annotations.Feature;
import net.fabricmc.loader.impl.lib.sat4j.core.VecInt;
import net.fabricmc.loader.impl.lib.sat4j.specs.ContradictionException;
import net.fabricmc.loader.impl.lib.sat4j.specs.IConstr;
import net.fabricmc.loader.impl.lib.sat4j.specs.ISolver;
import net.fabricmc.loader.impl.lib.sat4j.specs.IVecInt;
import net.fabricmc.loader.impl.lib.sat4j.specs.TimeoutException;
import net.fabricmc.loader.impl.lib.sat4j.tools.SolverDecorator;

@Feature(value="solver")
public class SingleSolutionDetector
extends SolverDecorator<ISolver> {
    private static final long serialVersionUID = 1L;

    public SingleSolutionDetector(ISolver solver) {
        super(solver);
    }

    public boolean hasASingleSolution() throws TimeoutException {
        return this.hasASingleSolution(new VecInt());
    }

    public boolean hasASingleSolution(IVecInt assumptions) throws TimeoutException {
        int[] firstmodel = this.model();
        assert (firstmodel != null);
        VecInt clause = new VecInt(firstmodel.length);
        for (int q : firstmodel) {
            clause.push(-q);
        }
        boolean result = false;
        try {
            IConstr added = this.addClause(clause);
            result = !this.isSatisfiable(assumptions);
            this.removeConstr(added);
        }
        catch (ContradictionException e) {
            result = true;
        }
        return result;
    }
}

