/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.lib.sat4j.tools.counting;

import java.math.BigInteger;
import net.fabricmc.loader.impl.lib.sat4j.specs.ISolver;
import net.fabricmc.loader.impl.lib.sat4j.specs.TimeoutException;
import net.fabricmc.loader.impl.lib.sat4j.tools.ModelIteratorToSATAdapter;
import net.fabricmc.loader.impl.lib.sat4j.tools.SolutionFoundListener;
import net.fabricmc.loader.impl.lib.sat4j.tools.counting.IModelCounter;

public final class ModelCounterAdapter
implements IModelCounter {
    private final ModelIteratorToSATAdapter adaptee;

    private ModelCounterAdapter(ISolver solver) {
        this.adaptee = new ModelIteratorToSATAdapter(solver, SolutionFoundListener.VOID);
    }

    public static ModelCounterAdapter newInstance(ISolver solver) {
        return ModelCounterAdapter.newInstance(solver, Long.MAX_VALUE);
    }

    public static ModelCounterAdapter newInstance(ISolver solver, long bound) {
        ModelCounterAdapter counter = new ModelCounterAdapter(solver);
        counter.setBound(bound);
        return counter;
    }

    public static BigInteger countModels(ISolver solver) {
        return ModelCounterAdapter.countModels(solver, Long.MAX_VALUE);
    }

    public static BigInteger countModels(ISolver solver, long bound) {
        ModelCounterAdapter counter = ModelCounterAdapter.newInstance(solver, bound);
        BigInteger nbModels = counter.countModels();
        counter.reset();
        return nbModels;
    }

    public void setBound(long bound) {
        this.adaptee.setBound(bound);
    }

    @Override
    public BigInteger countModels() {
        try {
            this.adaptee.isSatisfiable();
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        return BigInteger.valueOf(this.adaptee.numberOfModelsFoundSoFar());
    }

    @Override
    public void reset() {
        this.adaptee.clearBlockingClauses();
    }
}

