/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.lib.tinyremapper;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.zip.GZIPInputStream;
import net.fabricmc.loader.impl.lib.mappingio.FlatMappingVisitor;
import net.fabricmc.loader.impl.lib.mappingio.MappingReader;
import net.fabricmc.loader.impl.lib.mappingio.MappingVisitor;
import net.fabricmc.loader.impl.lib.mappingio.adapter.FlatAsRegularMappingVisitor;
import net.fabricmc.loader.impl.lib.mappingio.adapter.MappingDstNsReorder;
import net.fabricmc.loader.impl.lib.mappingio.adapter.MappingSourceNsSwitch;
import net.fabricmc.loader.impl.lib.tinyremapper.IMappingProvider;

public final class TinyUtils {
    private TinyUtils() {
    }

    public static IMappingProvider createTinyMappingProvider(Path mappings, String fromM, String toM) {
        return out -> {
            try (BufferedReader reader = TinyUtils.getMappingReader(mappings.toFile());){
                TinyUtils.read(reader, fromM, toM, out);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    private static BufferedReader getMappingReader(File file) throws IOException {
        InputStream is = new FileInputStream(file);
        if (file.getName().endsWith(".gz")) {
            is = new GZIPInputStream(is);
        }
        return new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
    }

    public static IMappingProvider createTinyMappingProvider(BufferedReader reader, String fromM, String toM) {
        return out -> {
            try {
                TinyUtils.read(reader, fromM, toM, out);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    private static void read(BufferedReader reader, String fromNs, String toNs, IMappingProvider.MappingAcceptor out) throws IOException {
        MappingReader.read(reader, (MappingVisitor)new MappingSourceNsSwitch(new MappingDstNsReorder((MappingVisitor)new FlatAsRegularMappingVisitor(new MappingAdapter(out)), toNs), fromNs));
    }

    private static boolean firstNullOrEqual(Object o1, Object o2) {
        return o1 == null || o1.equals(o2);
    }

    private static boolean bothNullOrEqual(Object o1, Object o2) {
        return o2 == null || TinyUtils.firstNullOrEqual(o1, o2);
    }

    private static final class MappingAdapter
    implements FlatMappingVisitor {
        private final IMappingProvider.MappingAcceptor next;

        MappingAdapter(IMappingProvider.MappingAcceptor next) {
            this.next = next;
        }

        @Override
        public boolean visitClass(String srcName, String[] dstNames) throws IOException {
            String dstName = dstNames[0];
            if (!TinyUtils.bothNullOrEqual(srcName, dstName)) {
                this.next.acceptClass(srcName, dstName);
            }
            return true;
        }

        @Override
        public boolean visitField(String srcClsName, String srcName, String srcDesc, String[] dstClsNames, String[] dstNames, String[] dstDescs) throws IOException {
            String dstName = dstNames[0];
            if (!TinyUtils.bothNullOrEqual(srcName, dstName)) {
                this.next.acceptField(new IMappingProvider.Member(srcClsName, srcName, srcDesc), dstName);
            }
            return false;
        }

        @Override
        public boolean visitMethod(String srcClsName, String srcName, String srcDesc, String[] dstClsNames, String[] dstNames, String[] dstDescs) throws IOException {
            String dstName = dstNames[0];
            if (!TinyUtils.bothNullOrEqual(srcName, dstName)) {
                this.next.acceptMethod(new IMappingProvider.Member(srcClsName, srcName, srcDesc), dstName);
            }
            return true;
        }

        @Override
        public boolean visitMethodArg(String srcClsName, String srcMethodName, String srcMethodDesc, int argPosition, int lvIndex, String srcArgName, String[] dstClsNames, String[] dstMethodNames, String[] dstMethodDescs, String[] dstArgNames) throws IOException {
            String dstName = dstArgNames[0];
            if (!TinyUtils.firstNullOrEqual(dstName, srcArgName)) {
                this.next.acceptMethodArg(new IMappingProvider.Member(srcClsName, srcMethodName, srcMethodDesc), lvIndex, dstName);
            }
            return false;
        }

        @Override
        public boolean visitMethodVar(String srcClsName, String srcMethodName, String srcMethodDesc, int lvtRowIndex, int lvIndex, int startOpIdx, int endOpIds, String srcVarName, String[] dstClsNames, String[] dstMethodNames, String[] dstMethodDescs, String[] dstVarNames) throws IOException {
            String dstName = dstVarNames[0];
            if (!TinyUtils.firstNullOrEqual(dstName, srcVarName)) {
                this.next.acceptMethodVar(new IMappingProvider.Member(srcClsName, srcMethodName, srcMethodDesc), lvIndex, startOpIdx, -1, dstName);
            }
            return false;
        }

        @Override
        public void visitNamespaces(String srcNamespace, List<String> dstNamespaces) throws IOException {
        }

        @Override
        public void visitClassComment(String srcName, String[] dstNames, String comment) throws IOException {
        }

        @Override
        public void visitFieldComment(String srcClsName, String srcName, String srcDesc, String[] dstClsNames, String[] dstNames, String[] dstDescs, String comment) throws IOException {
        }

        @Override
        public void visitMethodComment(String srcClsName, String srcName, String srcDesc, String[] dstClsNames, String[] dstNames, String[] dstDescs, String comment) throws IOException {
        }

        @Override
        public void visitMethodArgComment(String srcClsName, String srcMethodName, String srcMethodDesc, int argPosition, int lvIndex, String srcArgName, String[] dstClsNames, String[] dstMethodNames, String[] dstMethodDescs, String[] dstArgNames, String comment) throws IOException {
        }

        @Override
        public void visitMethodVarComment(String srcClsName, String srcMethodName, String srcMethodDesc, int lvtRowIndex, int lvIndex, int startOpIdx, int endOpIdx, String srcVarName, String[] dstClsNames, String[] dstMethodNames, String[] dstMethodDescs, String[] dstVarNames, String comment) throws IOException {
        }
    }
}

